/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.asistentes.exportaciones;

import ec.gob.sri.dimm.api.ui.asistentes.AsistenteBase;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.obj.exportacion.Exportacion;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones.PaginaCliente;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones.PaginaComprobante;
import ec.gob.sri.dimm.ats.ui.asistentes.paginas.exportaciones.PaginaRefrendo;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;

public class AsistenteNuevaExportacion
extends AsistenteBase
implements INewWizard {
    private PaginaCliente paginaCliente;
    private PaginaRefrendo paginaRefrendo;
    private PaginaComprobante paginaComprobante;
    private Periodo periodo;
    public static final String ID = "ec.gob.sri.dimm.ats.ui.asistentes.exportaciones.AsistenteNuevaExportacion";
    private final Exportacion modeloDatos;
    private boolean editando;

    public AsistenteNuevaExportacion(Exportacion exportacion, boolean editando, Periodo periodo) {
        this.modeloDatos = exportacion;
        this.modeloDatos.getComprobanteExportacion().setObligatorio(true);
        this.editando = editando;
        this.periodo = periodo;
    }

    public void addPages() {
        this.paginaCliente = new PaginaCliente(this.editando, ((Iva)this.modeloDatos.getPropietario()).periodo);
        this.paginaCliente.setModeloDatos(this.modeloDatos.getClienteExportacion());
        this.paginaCliente.inicializarModeloValores();
        this.paginaRefrendo = new PaginaRefrendo(this.editando);
        this.paginaRefrendo.setModeloDatos(this.modeloDatos);
        this.paginaRefrendo.inicializarModeloValores();
        this.paginaComprobante = new PaginaComprobante(this.editando);
        this.paginaComprobante.setModeloDatos(this.modeloDatos.getComprobanteExportacion());
        this.paginaComprobante.inicializarModeloValores();
        if (this.periodo.isPeriodoDeAnexoDesdeMarzo2015()) {
            this.addPage((IWizardPage)this.paginaCliente);
        }
        this.addPage((IWizardPage)this.paginaRefrendo);
        this.addPage((IWizardPage)this.paginaComprobante);
    }

    public boolean performFinish() {
        return true;
    }
}

